//--------------------------------------------------------------------
// demo.cpp for I-8090 card
//
//demo.exe: This program can get overall I-8090 cards on the slots, and display
//          X,Y,Z axis encoder value on the LED display.
//
//1. including DEMO.CPP, 8000L.LIB,i8090.LIB
//   compile under "large" mode
//
//2. download file and execution:
//    (1) execute 7188x.exe under DOS environment
//    (2) press F2 to set file to download, demo.exe
//    (3) press F9/F8 to auto-download file
//    (4) demo to execute
//
//3. operation of demo.exe
//    (1) 'Mode' Key : select card, slot by slot
//                     - - - - 0, no any card on slot 0
//                     - - - - 1, no any card on slot 1
//                     8 0 9 0 2, I-8090 card on slot 2
//    (2) 'Set' Key  :  select this slot to show encoder on the LED display
//    (3) '<','>'    :  select axis, the dot(.) indicate which axis
//                      ex:  0.0 5 1 8  X-axis value
//                           6 3.0 9 0  Y-axis value
//                           1 0 6.2 3  Z-axis value
//--------------------------------------------------------------------
// v1.0  6/20/2001
//
//--------------------------------------------------------------------
#include <dos.h>
#include <math.h>
#include "8000.h"
#include "i8090.h"

#define i8090  0x0d
#define i8091  0x0e
#define i8092  0x0f
#define NOCARD 0x00

#define Insert          0x0000
#define BasePort        0x0080
#define SlotOffset      0x0020
#define IDPort          0x0000
                         
#define CARD0  0
#define CARD1  1
#define CARD2  2
#define CARD3  3
#define CARD4  4
#define CARD5  5
#define CARD6  6
#define CARD7  7

#define MAX_SLOT_NO  8
unsigned int PortAddress[8]={0x080, 0x0a0, 0x0c0, 0x0e0, 0x140, 0x160, 0x180, 0x1a0};
//--------------------------------------------------------------------
void ShowLedValue(long value,unsigned char axis)
{
long j;                         
unsigned char negative_value;

  if (value<0) negative_value=1; 
  else         negative_value=0;
  value=labs(value);                          
                                            
  j=value-10*(value/10);     
  if (negative_value) Show5DigitLedWithDot(0x05, j);
  else                Show5DigitLed(0x05, j); 
  
  value=value/10;
  j=value-10*(value/10);
  Show5DigitLed(0x04, j);
  value=value/10;
  j=value-10*(value/10);
  if (axis==Z_axis) Show5DigitLedWithDot(0x03, j);
  else              Show5DigitLed(0x03, j);
  value=value/10;
  j=value-10*(value/10);
  if (axis==Y_axis) Show5DigitLedWithDot(0x02, j);
  else              Show5DigitLed(0x02, j);
  value=value/10;
  j=value-10*(value/10);
  if (axis==X_axis) Show5DigitLedWithDot(0x01, j);
  else              Show5DigitLed(0x01, j);
}  
//---------------------------------------------------
void ShowCardName(unsigned char SlotNum)
{
unsigned char temp;

   Show5DigitLed(0x05, SlotNum);
   //temp=inportb(BasePort+SlotNum*SlotOffset); 
   temp=inportb(PortAddress[SlotNum]);
   switch (temp)
   {
      case i8090: //i8090 3-axis encoder card
		Show5DigitLedSeg (0x01, 0x7F);
		Show5DigitLedSeg (0x02, 0x7E);
		Show5DigitLedSeg (0x03, 0x7B);
		Show5DigitLedSeg (0x04, 0x7E);
		break;
      case i8091: //i8091 2-axis stepping card
		Show5DigitLedSeg (0x01, 0x7F);
		Show5DigitLedSeg (0x02, 0x7E);
		Show5DigitLedSeg (0x03, 0x7B);
		Show5DigitLedSeg (0x04, 0x30);
		break;    
      case i8092: //i8092 
		Show5DigitLedSeg (0x01, 0x7F);
		Show5DigitLedSeg (0x02, 0x7E);
		Show5DigitLedSeg (0x03, 0x7B);
		Show5DigitLedSeg (0x04, 0x6D);
		break;		
      default:
		Show5DigitLedSeg (0x01, 0x01);
		Show5DigitLedSeg (0x02, 0x01);
		Show5DigitLedSeg (0x03, 0x01);
		Show5DigitLedSeg (0x04, 0x01);
		break;
   };
}
//---------------------------------------------------
unsigned char CardSearch(unsigned char SlotNum)
{
unsigned char temp;

   //temp=inportb(BasePort+SlotNum*SlotOffset);
   temp=inportb(PortAddress[SlotNum]);
   ShowCardName(SlotNum);
   switch (temp)
   {
      case i8090: //i8090 3-axis encoder card
		Print("Slot %d = i8090\r\n",SlotNum);
		return i8090;
      case i8091: //i8091 2-axis stepping card
		Print("Slot %d = i8091\r\n",SlotNum);
		return i8091;  
      case i8092: //i8092 
		Print("Slot %d = i8092\r\n",SlotNum);
		return i8092;		
      default:
		Print("Slot %d = No Card\r\n",SlotNum);
		return NOCARD;
   };
}

//---------------------------------------------------------------------------------
void main ()
{
unsigned char slot;
unsigned int  x_value;
unsigned int  y_value;
unsigned int  z_value;
unsigned char index;
unsigned char x_index;
unsigned char y_index;
unsigned char z_index;
int           key,ShowAxis,ShowSlot,ShowFlag;

          
Print("-----------------------------------------------------------------------\r\n"); 
Print(" I-8090 DEMO program   demo.PRJ, demo.cpp, i8090.lib                    \r\n");       
Print(" Show every axis's encoder value of each card on LED display           \r\n");
Print(" 'Mode' Key :  select slot                                             \r\n");
Print("               ex:  - - - - 0, no any card on slot 0                   \r\n");
Print("                    - - - - 1, no any card on slot 1                   \r\n");
Print("                    8 0 9 0 2, I-8090 card on slot 2                    \r\n");
Print(" 'Set' Key  :  select this slot to show encoder on the LED display     \r\n");
Print(" '<','>'    :  select axis, the dot(.) indicate which axis             \r\n");
Print("               ex:  0.0 5 1 8  X-axis value                            \r\n");
Print("                    6 3.0 9 0  Y-axis value                            \r\n");
Print("                    1 0 6.2 3  Z-axis value                            \r\n");
Print("-----------------------------------------------------------------------\r\n");
          
  for (slot=0; slot<MAX_SLOT_NO; slot++)
  {                                
    if (CardSearch(slot)==i8090)
    {
       if (i8090_REGISTRATION(slot, PortAddress[slot])==YES)
       {
	  i8090_INIT_CARD(slot, ENC_QUADRANT, ENC_QUADRANT, ENC_QUADRANT);
	  i8090_RESET_ENCODER(slot, X_axis);
	  i8090_RESET_ENCODER(slot, Y_axis);
	  i8090_RESET_ENCODER(slot, Z_axis);
	  ShowSlot=slot;
	  ShowFlag=1;
       }
    };
    Delay(500);
  };

  Print("Press any key to stop...\r\n");

  ClearSystemKey();
  ShowAxis=0;
  //ShowSlot=0;
  //ShowFlag=0;
  do
  {
      x_value = i8090_GET_ENCODER(ShowSlot, X_axis);
      y_value = i8090_GET_ENCODER(ShowSlot, Y_axis);
      z_value = i8090_GET_ENCODER(ShowSlot, Z_axis);
      index   = i8090_GET_INDEX(ShowSlot);
      x_index = index & 0x01;
      y_index = (index & 0x02) >> 1;
      z_index = (index & 0x04) >> 2;

      if (IsSystemKey())
      {
	 key=GetSystemKey();
	 ClearSystemKey();
	 switch (key)
	 {
	   case SKEY_DOWN:
			 if (ShowFlag==0) break;
			 ShowAxis++;
			 if (ShowAxis>2) ShowAxis=0;
			 break;
	   case SKEY_UP:
			 if (ShowFlag==0) break;
			 ShowAxis--;
			 if (ShowAxis<0) ShowAxis=2;
			 break;
	   case SKEY_MODE:
			 ShowFlag=0;
			 ShowSlot++;
			 if (ShowSlot>=MAX_SLOT_NO) ShowSlot=0;
			 break;
	   case SKEY_SET:
			 ShowFlag=1;
			 break;
	 };
      }

      if (ShowFlag==1)
      {
	 switch (ShowAxis)
	 {
	    case 0: ShowLedValue(x_value,X_axis); break;
	    case 1: ShowLedValue(y_value,Y_axis); break;
	    case 2: ShowLedValue(z_value,Z_axis); break;
	 };
	 if (x_index) LedRunOff();  else LedRunOn();
	 if (y_index) LedCommOff(); else LedCommOn();
	 if (z_index) LedBattOff(); else LedBattOn();
      }
      else
	 ShowCardName(ShowSlot);

      Delay(5);

  } while (!Kbhit());
}